<?php
function ConvertStringTo32Dec($val)
{
   $val = strrev(decbin($val));
   if (strlen($val) == 64) {
      $val = substr($val, 0, 32);
   }
   if (strlen($val) < 64) {
      $val = str_pad($val, 32, 0);
   }
   return $val;
}
function getPropertyDeny($user, $part, $property)
{
   if (!isset($user->deny) || !isset($user->deny->$part)) {
      return str_pad("", 128, 0);
   }
   $cameraPolicy = sort_nested_arrays($user->deny->$part, ["index" => "desc"]);
   $result = [];

   foreach ($cameraPolicy as $cam) {
      if (isset($cam->$property)) {
         array_push($result, ["index" => $cam->index, "value" => ConvertStringTo32Dec($cam->$property)]);
      }
   }
   $result = sort_nested_arrays($result, ["index" => "desc"]);
   $temp = [];
   for ($i = 0; $i < 4; $i++) {
      array_push($temp, ["index" => $i, "value" => str_pad("", 32, 0)]);
   }
   foreach ($temp as $t) {
      foreach ($result as $r) {
         if ($t["index"] == $r["index"]) {
            $temp[$r["index"]]["value"] = $r["value"];
            break;
         }
      }
   }
   $result = [$temp[0]["value"], $temp[1]["value"], $temp[2]["value"], $temp[3]["value"]];
   $result = join("", $result);
   return $result;
}
function checkCameraDeny_read($user)
{
   if (!isset($user->deny) || !isset($user->deny->camera)) {
      return str_pad("", 128, 0);
   }
   $cameraPolicy = sort_nested_arrays($user->deny->camera, ["index" => "desc"]);
   $read = [];
   $cam_index = 0;
   foreach ($cameraPolicy as $cam) {
      foreach ($cam as $key => $value) {
         if ($key == "read") {
            array_push($read, ["index" => $cam->index, "value" => ConvertStringTo32Dec($value)]);
         }
      }
      $cam_index = $cam_index + 1;
   }
   $read = sort_nested_arrays($read, ["index" => "desc"]);
   $temp = [];
   for ($i = 0; $i < 4; $i++) {
      array_push($temp, ["index" => $i, "value" => str_pad("", 32, 0)]);
   }
   foreach ($temp as $t) {
      foreach ($read as $r) {
         if ($t["index"] == $r["index"]) {
            $temp[$r["index"]]["value"] = $r["value"];
            break;
         }
      }
   }
   $read = [$temp[0]["value"], $temp[1]["value"], $temp[2]["value"], $temp[3]["value"]];
   $read = join("", $read);
   return $read;
}
function getDenyAccess($user)
{
   $result = [];
   $result["read"] = getPropertyDeny($user, "camera", "read");
   $result["write"] = getPropertyDeny($user, "camera", "write");
   $result["play"] = getPropertyDeny($user, "camera", "play");
   $result["ptz"] = getPropertyDeny($user, "camera", "ptz");
   $result["soundRead"] = getPropertyDeny($user, "sound", "read");
   $result["soundPlay"] = getPropertyDeny($user, "sound", "play");
   return $result;
}
